<?php

App::uses('AppModel', 'Model');

class Page extends AppModel
{

    public $belongsTo = array('User');
    public $validate = array(
        'title' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
                'message' => 'title can not be empty.'
            )
        ),
        'slug' => array(
            'isUnique' => array(
                'rule' => 'isUnique',
                'required' => true,
                'allowEmpty' => true,
                'message' => 'Slug must be unique.'
            )
        ),
        'menu' => array(
            'inList' => array(
                'rule' => array('inList', array('0', '1')),
                'message' => 'Choose a valid value.',
            ),
        ),
        'published' => array(
            'inList' => array(
                'rule' => array('inList', array('0', '1')),
                'message' => 'Choose a valid value.',
            ),
        ),
    );

    //http://www.whatstyle.net/articles/52/generate_unique_slugs_in_cakephp
    public function create_slug($string, $id = null)
    {
        $slug = Inflector::slug($string, '-');
        $slug = mb_strtolower($slug);
        $i = 0;
        $params = array();
        $params ['conditions'] = array();
        $params ['conditions']['Page.slug'] = $slug;
        if (!is_null($id)) {
            $params ['conditions']['not'] = array('Page.id' => $id);
        }
        while (count($this->find('all', $params))) {
            if (!preg_match('/-{1}[0-9]+$/', $slug)) {
                $slug .= '-' . ++$i;
            } else {
                $slug = preg_replace('/[0-9]+$/', ++$i, $slug);
            }
            $params ['conditions']['Page.slug'] = $slug;
        }
        return $slug;
    }
    
    public function afterSave($created, $options = array())
    {
        
    }
}
